import os


def validate_int(i, offset, l, h):
    ret = -1
    if i.isdigit():
        num = int(i)-offset
        if num >= l and num <= h:
            ret = num
    return ret


def isfloat(value):
    try:
        float(value)
        return True
    except ValueError:
        return False


def validate_float(f):
    ret = -1
    if isfloat(f):
        num = float(f)
        if num >= 0:
            ret = num
    return ret


def get_num_value(name):
    l = -1
    while l < 0:
        i = input(name+": ")
        if i == "q":
            return None, True
        l = validate_float(i)
    return l, False


def main():
    os.system('cls')
    print()
    print("Volumen- und Oberflächenrechner")
    print("===============================")
    print()
    print("1: Kugel")
    print("q: Beenden")
    print()
    l = -1
    while l < 0:
        i = input("Wähle einen Körper: ")
        if i == "q":
            return None, True
        l = validate_int(i, 0, 1, 3)
    return l, False


def get_params(body, names):
    os.system('cls')
    print()
    print(body)
    for i in range(len(body)):
        print("-", end="")
    print()
    print()
    ret = []
    for n in names:
        f, q = get_num_value(n)
        if q == True:
            return None, True
        ret.append(f)
    return ret, False
