import os
from PIL import Image, ImageDraw
from pathlib import Path
import sys
print(os.getcwd())

"""
CREATES PNG-FILES OF COLORFUL BALLS
"""

# CONSTANTS
PATH = Path("data/")

# Define colors
WHITE = (255, 255, 255)
BLACK = (0, 0, 0)
RED = (255, 0, 0)
GREEN = (0, 255, 0)
BLUE = (0, 0, 255)

def draw_bmp_circle(radius,color):
    """
    creates circle image and saves on disk
    """
    # CREATE BALL IMAGE (if does not exist yet)
    if not os.path.exists(PATH):
        os.makedirs(PATH)

    file_path = Path(f"{PATH}/ball_r={radius}_col={str(color).replace(' ','').replace(',','_').replace(')','').replace('(','')}.png")

    if not os.path.isfile(file_path):
        img = Image.new('RGBA', (radius,radius), (255, 0, 0, 0))
        draw = ImageDraw.Draw(img)
        draw.ellipse((0,0,radius-1,radius-1), fill=color)
        img.save(file_path, 'PNG')

if __name__ == "__main__":
    draw_bmp_circle(30,RED)
    draw_bmp_circle(30,GREEN)
    