﻿using System;
using System.Collections.Generic;

namespace ConsoleGames.Games2024
{
    internal class Memory : Game
    {
        public override string Name => "Memory";
        public override string Description => "Find all pairs as fast as possible, use wasd to move to a card and turn it with enter. (game doesn't work yet :(( )";

        public override string Rules => "If the cards aren't identical they are turned around again. If they're the same they're eliminated.";

        public override string Credits => "Amos Forrer - amforrer@ksr.ch";

        public override int Year => 2023;

        public override int LevelMax => 3;

        public override bool TheHigherTheBetter => false;

        public override Score HighScore { get; set; }


        public override Score Play(int level = 1)
        {
            int FirstPlayerPositionX = 0;
            int FirstPlayerPositionY = 0;
            int counter = 0;
            int counter2 = 0;
            int PlayerPositionX = 0;
            int PlayerPositionY = 0;
            int turns = 0;
            Score score = new Score();
            bool success = false;

            string[] card1 =
            {
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrwwwwwwwwwwwwrrrr",
                "rrrrwwwwwwwwwwwwrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr"
            };
            string[] card2 =
            {
                "bbbbbbbbbbbbbbbbbbbb",
                "bbbbbbbbbbbbbbbbbbbb",
                "bbbbbbbbbbbbbbbbbbbb",
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "yyyyyyyyyyyyyyyyyyyy",
                "yyyyyyyyyyyyyyyyyyyy",
                "yyyyyyyyyyyyyyyyyyyy",
                "bbbbbbbbbbbbbbbbbbbb"
            };
            string[] card3 =
            {
                "bbbbbbbbbbbbbbbbbbbb",
                "bggggggwwwwwwrrrrrrb",
                "bggggggwwwwwwrrrrrrb",
                "bggggggwwwwwwrrrrrrb",
                "bggggggwwwwwwrrrrrrb",
                "bggggggwwwwwwrrrrrrb",
                "bggggggwwwwwwrrrrrrb",
                "bggggggwwwwwwrrrrrrb",
                "bggggggwwwwwwrrrrrrb",
                "bbbbbbbbbbbbbbbbbbbb"
            };
            string[] card4 =
            {
                "bbbbbbbbbbbbbbbbbbbb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bhhhhhhwwwwwwrrrrrrb",
                "bbbbbbbbbbbbbbbbbbbb"
            };
            string[] card5 =
            {
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "wwwwwwwwwwwwwwwwwwww",
                "wwwwwwwwwwwwwwwwwwww",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr",
                "rrrrrrrrwwwwrrrrrrrr"
            };
            string[] card6 =
            {
                "rrrrwhhwrrrrrrrrrrrr",
                "rrrrwhhwrrrrrrrrrrrr",
                "rrrrwhhwrrrrrrrrrrrr",
                "rrrrwhhwrrrrrrrrrrrr",
                "wwwwwhhwwwwwwwwwwwww",
                "hhhhhhhhhhhhhhhhhhhh",
                "wwwwwhhwwwwwwwwwwwww",
                "rrrrwhhwrrrrrrrrrrrr",
                "rrrrwhhwrrrrrrrrrrrr",
                "rrrrwhhwrrrrrrrrrrrr",
            };
            string[] card7 =
            {
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "wwwwwwwwwwwwwwwwwwww",
                "wwwwwwwwwwwwwwwwwwww",
                "wwwwwwwwwwwwwwwwwwww",
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "rrrrrrrrrrrrrrrrrrrr",
                "bbbbbbbbbbbbbbbbbbbb"
            };
            string[] card8 =
            {
                "whwhwhwhwhwwwwwwwwww",
                "hwhwhwhwhwrrrrrrrrrr",
                "whwhwhwhwhwwwwwwwwww",
                "hwhwhwhwhwrrrrrrrrrr",
                "whwhwhwhwhwwwwwwwwww",
                "rrrrrrrrrrrrrrrrrrrr",
                "wwwwwwwwwwwwwwwwwwww",
                "rrrrrrrrrrrrrrrrrrrr",
                "wwwwwwwwwwwwwwwwwwww",
                "rrrrrrrrrrrrrrrrrrrr"
            };
            string[] card9 =
            {
                "hhhhhhhhhhhhhhhhhhhh",
                "hhhhhhhhhhhhhhhhhhhh",
                "hhhhhhhhhhhhhhhhhhhh",
                "wwwwwwwwyyyywwwwwwww",
                "wwwwwwwyyyyyywwwwwww",
                "wwwwwwwwyyyywwwwwwww",
                "hhhhhhhhhhhhhhhhhhhh",
                "hhhhhhhhhhhhhhhhhhhh",
                "hhhhhhhhhhhhhhhhhhhh",
                "bbbbbbbbbbbbbbbbbbbb"
            };
            string[] card10 =
            {
                "wwwwwwwwwwwwwwwwwwww",
                "wwwwwwwwwwwwwwwwwwww",
                "wwwwwwrrwwwwrrwwwwww",
                "wwwwrrrrrwwrrrrrwwww",
                "wwwwrrrrrrrrrrrrwwww",
                "wwwwwwrrrrrrrrwwwwww",
                "wwwwwwwwrrrrwwwwwwww",
                "wwwwwwwwwwwwwwwwwwww",
                "wwwwwwwwwwwwwwwwwwww",
                "wwwwwwwwwwwwwwwwwwww"
            };
            string[] card11 =
            {
                "wwwwwbbbbbbbbbbwwwww",
                "wwbbbyyyyyyyyyybbbww",
                "wbbyyyyyyyyyyyyyybbw",
                "bbyyybbyyyyyybbyyybb",
                "byyyyyyyyyyyyyyyyyyb",
                "bbyyybyyyyyyyybyyybb",
                "wbbyyybbbbbbbbyyybbw",
                "wwbbbyyyyyyyyyybbbww",
                "wwwwwbbbbbbbbbbwwwww",
                "wwwwwwwwwwwwwwwwwwww"
            };
            string[] card12 =
            {
                "wwwwwbbbbbbbbbbwwwww",
                "wwbbbyyyyyyyyyybbbww",
                "wbbyyyyyyyyyyyyyybbw",
                "bbyyybbyyyyyybbyyybb",
                "byyyyyyyyyyyyyyyyyyb",
                "bbyyyybbbbbbbbyyyybb",
                "wbbyybyyyyyyyybyybbw",
                "wwbbyyyyyyyyyyyybbww",
                "wwwwwbbbbbbbbbbwwwww",
                "wwwwwwwwwwwwwwwwwwww"
            };
            string[] card13 =
            {
                "wwwwwbbbbbbbbbbwwwww",
                "wwbbbyyyyyyyyyybbbww",
                "wbbybbbbyyyybbbbybbw",
                "bbybbrrbbyybbrrbbybb",
                "byyybbbbyyyybbbbyyyb",
                "bbyyyyyyyyyyyyyyyybb",
                "wbbyyybybybybyyyybbw",
                "wwbbyyybybybybyybbww",
                "wwwwbbyyyyyyyybbwwww",
                "wwwwwwbbbbbbbbwwwwww"
            };
            string[] card14 =
            {
                "wwwwwbbbbbbbbbbwwwww",
                "wwbbbyyyyyyyyyybbbww",
                "wbbyyyyyyyyyyyyyybbw",
                "bbyyyhhyyyyyyhhyyybb",
                "byyhhyyhhyyhhyyhhyyb",
                "bbyyybyyyyyyyybyyybb",
                "wbbyyybbbbbbbbyyybbw",
                "wwbbyyyyyyyyyyyybbww",
                "wwwwwbbbbbbbbbbwwwww",
                "wwwwwwwwwwwwwwwwwwww"
            };
            string[] card15 =
            {
                "wwwwwbbbbbbbbbbwwwww",
                "wwbbbyyyyyyyyyybbbww",
                "wbbyyyyyyyyyyyyyybbw",
                "bbyyybbyyyyyybbyyybb",
                "byyyyyyyyyyyyyyyyyyb",
                "bbyyyyyyyyyyyyyyyybb",
                "wbbyyybbbbbbbbyyybbw",
                "wwbbbyyyyyyyyyybbbww",
                "wwwwwbbbbbbbbbbwwwww",
                "wwwwwwwwwwwwwwwwwwww"
            };
            string[] card16 =
            {
                "wwwwwbbbbbbbbbbwwwww",
                "wwbbbyyyyyyyyyybbbww",
                "wbbyybybyyyybybyybbw",
                "bbyyyybyyyyyybyyyybb",
                "byyyybybyyyybybyyyyb",
                "bbyyyyyyyyyyyyyyyybb",
                "wbbyyybbbbrrbbyyybbw",
                "wwbbbyyyyyrryyybbbww",
                "wwwwwbbbbbbbbbbwwwww",
                "wwwwwwwwwwwwwwwwwwww"
            };
            string[] card17 =
            {
                "hhhhhhhhhbbhhhhhhhhh",
                "hhhhhhhhbwwbhhhhhhhh",
                "hhhhhhhbwwwwbhhhhhhh",
                "hhhhhhbwwwwwwbhhhhhh",
                "hhhhhbwwwwwwwwbhhhhh",
                "hhhhhbbbbbbbbbbhhhhh",
                "hhhhhbbbbbbbbbbhhhhh",
                "kkkkkbbbbbbbbbbkkkkk",
                "kkkkkbbbbbbbbbbkkkkk",
                "kkkkkkkkkkkkkkkkkkkk"
            };
            string[] card18 =
            {
                "wwwwwwwwwwwwwwwwwwww",
                "wwwbbwwwbbwwwbbwwwww",
                "wwbwbwwbwbwwbwbwwwww",
                "wbbwbbbbwbbbbwbbbwww",
                "wbbwwwwwwwwwwwwbbwww",
                "wbbwwwwwwwwwwwwbbwww",
                "wbbwwwwwwwwwwwwbbwww",
                "wbbwwwwwwwwwwwwbbwww",
                "wbbbbbbbbbbbbbbbbwww",
                "wwwwwwwwwwwwwwwwwwww"
            };

            string[] back =
            {
                "whwhwhwhwhwhwhwhwhwh",
                "hwhwhwhwhwhwhwhwhwhw",
                "whwhwhwhwhwhwhwhwhwh",
                "hwhwhwhwhwhwhwhwhwhw",
                "whwhwhwhwhwhwhwhwhwh",
                "hwhwhwhwhwhwhwhwhwhw",
                "whwhwhwhwhwhwhwhwhwh",
                "hwhwhwhwhwhwhwhwhwhw",
                "whwhwhwhwhwhwhwhwhwh",
                "hwhwhwhwhwhwhwhwhwhw"
            };
            string[][] firstcards = new string[][]//this string contains all the cards. The cards are mixed in this string.
            {
                card1, card2, card3, card4, card5, card6, card7, card8, card9, card10, card11, card12, card13, card14, card15, card16, card17, card18
            };

            string[][] cards = new string[][]//This string contains the cards that are shown, at the beginning only the backsites, because none has been turned around yet. 
            {
                back, back, back, back ,back , back , back , back , back, back, back, back, back, back, back, back, back, back
            };
            (int[,] cardpositions, int size) = randomPositions(level);
            while (true)
            {
                while (true)
                {
                    string action = playerinput(ref PlayerPositionX, ref PlayerPositionY, size);
                    UpgradedView(PlayerPositionX, PlayerPositionY, action, size, cardpositions, ref cards, ref firstcards, success); //view turns shows where the player is and turns the cards around. 
                    if (action == "e")
                    {
                        //turn card
                        counter++;
                        if (counter == 1) { FirstPlayerPositionX = PlayerPositionX; FirstPlayerPositionY = PlayerPositionY; }
                        turns++; //turn two cards, then the code checks whether they are similar or not. If they are, their front sides should now be visible for the rest of the game.

                    }
                    if (counter == 2) { break; }
                }
                counter = 0;
                CheckforSuccess(cardpositions, PlayerPositionX, PlayerPositionY, FirstPlayerPositionX, FirstPlayerPositionY, ref cards, firstcards, size, ref success);
                UpgradedView(PlayerPositionX, PlayerPositionY, "t", size, cardpositions, ref cards, ref firstcards, success);
                if (CheckforWin(cards, size, firstcards, cardpositions))
                {
                    break;
                }
                counter2++;
            }
            if (turns <= size * 10)
            {
                score.LevelCompleted = true;
            }
            else
            {
                score.LevelCompleted = false;
            }
            score.Points = turns;
            return score;
        }

        private (int[,], int) randomPositions(int level)
        {
            Random random = new Random();
            int size = 0;
            int[] numbers;
            int counter = 0;
            int counter2 = 0;
            if (level == 0)
            {
                size = 2;
                numbers = new int[] { 0, 1, };
            }
            else if (level == 1)
            {
                size = 4;
                numbers = new int[] { 0, 1, 2, 3, 4, 5, 6, 7, };
            }
            else if (level == 2)
            {
                size = 6;
                numbers = new int[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 };
            }
            else
            {
                throw new ArgumentException("Invalid level");
            }
            int[,] cardpositions = new int[size, size];

            for (int i = 0; i < numbers.Length; i++)
            {
                while (counter < 2)
                {
                    int randomX = random.Next(0, size);
                    int randomY = random.Next(0, size);
                    if (cardpositions[randomX, randomY] == '\0')
                    {
                        cardpositions[randomX, randomY] = numbers[i]; //Depending on the level, the numbers of one of the three strings are moved to random places.
                        counter++;
                    }
                }
                counter = 0;
            }
            return (cardpositions, size);
        }

        private string playerinput(ref int PlayerPositionX, ref int PlayerPositionY, int size) //straightforward
        {
            string direction = "";
            while (true)
            {

                ConsoleKeyInfo keyinfo = Console.ReadKey();
                if (keyinfo.Key == ConsoleKey.W)
                {
                    if (PlayerPositionY >= 1)
                    {
                        PlayerPositionY -= 1;
                        direction = "w";
                        break;
                    }
                }

                else if (keyinfo.Key == ConsoleKey.A)
                {
                    if (PlayerPositionX >= 1)
                    {
                        PlayerPositionX -= 1;
                        direction = "a";
                        break;
                    }
                }

                else if (keyinfo.Key == ConsoleKey.S)
                {
                    if (PlayerPositionY < size - 1)
                    {
                        PlayerPositionY += 1;
                        direction = "s";
                        break;
                    }
                }

                else if (keyinfo.Key == ConsoleKey.D)
                {
                    if (PlayerPositionX < size - 1)
                    {
                        PlayerPositionX += 1;
                        direction = "d";
                        break;
                    }
                }

                else if (keyinfo.Key == ConsoleKey.Enter) { direction = "e"; break; }
            }
            return (direction);
        }

        private void CheckforSuccess(int[,] cardpositions, int PlayerPositionX, int PlayerPositionY, int FirstPlayerPositionX, int FirstPlayerPositionY, ref string[][] cards, string[][] firstcards, int size, ref bool success) //checks whether the two turned cards are a pair. 
        {
            if (firstcards[cardpositions[PlayerPositionX, PlayerPositionY]] == firstcards[cardpositions[FirstPlayerPositionX, FirstPlayerPositionY]])
            {
                success = true;
                cards[PlayerPositionX + PlayerPositionY * size] = firstcards[cardpositions[PlayerPositionX, PlayerPositionY]];
                cards[FirstPlayerPositionX + FirstPlayerPositionY * size] = firstcards[cardpositions[FirstPlayerPositionX, FirstPlayerPositionY]]; //Also adds both to the card list.Therefore they should be shown for the rest of the game.
            }
            else
            {
                success = false;
            }
        }

        private bool CheckforWin(string[][] cards, int size, string[][] firstcards, int[,] cardpositions)
        {
            for (int i = 0; i < size; i++)
            {
                for (int j = 0; j < size; j++)
                {
                    if (cards[j + i * size] != firstcards[cardpositions[i, j]])
                    {
                        //Console.WriteLine("jonathan");
                        return false;
                    }
                }
            }
            return true;
        }

        private void UpgradedView(int PlayerPositionX, int PlayerPositionY, string action, int size, int[,] cardpositions, ref string[][] cards, ref string[][] firstcards, bool success)
        {
            int ycalculator = PlayerPositionY;
            int counterLine = 0;
            int counterCard = 0;

            string[] safecard = cards[PlayerPositionX + ycalculator * size];
            string[] modifiedcard = new string[safecard.Length];
            Array.Copy(safecard, modifiedcard, safecard.Length);

            modifiedcard[0] = "ghghghghghghghghghgh";
            modifiedcard[9] = "hghghghghghghghghghg";
            cards[PlayerPositionX + ycalculator * size] = modifiedcard; //red bars that show where the player is 
            if (action == "e")
            {
                cards[PlayerPositionX + ycalculator * size] = firstcards[cardpositions[PlayerPositionX, PlayerPositionY]]; //card is turned
            }

            for (int x = 0; x < size; x++)
            {
                for (int y = 0; y < size; y++)
                {
                    paint(cards[counterCard], y, x);
                    counterCard++;
                }
            }
            cards[PlayerPositionX + ycalculator * size] = safecard; //resets the red bars
        }
        private void paint(string[] card, int counterx, int countery) //use simple library to paint the cards with strings.
        {
            Dictionary<string, ConsoleColor> ColorTranslation = new Dictionary<string, ConsoleColor>();
            ColorTranslation.Add("w", ConsoleColor.White);
            ColorTranslation.Add("r", ConsoleColor.Red);
            ColorTranslation.Add("y", ConsoleColor.Yellow);
            ColorTranslation.Add("b", ConsoleColor.Black);
            ColorTranslation.Add("g", ConsoleColor.Green);
            ColorTranslation.Add("h", ConsoleColor.Blue);
            ColorTranslation.Add("k", ConsoleColor.Gray);


            int x = counterx * 24;
            int y = countery * 12;
            Console.SetCursorPosition(x, y);

            foreach (string row in card)
            {
                foreach (char c in row)
                {
                    if (ColorTranslation.TryGetValue(c.ToString(), out ConsoleColor color))
                    {
                        Console.BackgroundColor = color;
                        Console.ForegroundColor = color;
                        Console.Write(c);
                        Console.ResetColor();
                    }
                }
                y++;
                Console.SetCursorPosition(x, y);

            }
        }
        bool ContainsBack(string[][] cards, string[] back) //used in check for win, checks whether there are still some unturned cards in the game. If so, game hasn't finished yet. 
        {
            foreach (string[] row in cards)
            {
                bool match = true;
                for (int i = 0; i < row.Length; i++)
                {
                    if (row[i] != back[i])
                    {
                        match = false;
                        break;
                    }
                }
                if (match)
                {
                    return true;
                }
            }
            return false;
        }
    }
}