﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace ConsoleGames.Games2024
{
    public class CarGame : Game
    {
        public override string Name => "CarGame";

        public override string Description => "Steuere dein Auto, ohne mit dem Strassenrand zu kollidieren";

        public override string Rules => "Verwende die Pfeiltasten um das Auto zu steuern. Sobald das Auto den Strassenrand berührt, ist Game Over";

        public override string Credits => "Rejda Bajramoska rebajram@ksr.ch";

        public override int Year => 2023;

        public override int LevelMax => 4;

        public override bool TheHigherTheBetter => true;

        public override Score HighScore { get; set; }

        private int[] levelBundary = new int[] { 15, 12, 10, 5 };
        public override Score Play(int level = 1)
        {
            Score score = new Score();
            score.LevelCompleted = false;
            int streetwidth = 20;
            int carPosition = streetwidth / 2;
            int carVelocity = 0;
            bool gameRunning = true;
            int scorepoint = 0;
            bool levelCompleted = false;
            Random rand = new Random();
            int roadwidth = levelBundary[level];
            List<int> street = new List<int>(streetwidth);
            int leftegde = (streetwidth - roadwidth) / 2;
            string previous = "";
            for (int i = 0; i < streetwidth; i++)
            {
                street.Add(leftegde);
            }
            int rightedge = street[0] + roadwidth;
            int[][] streetelements = new int[][] {
    //new int[] {0,1,2,3,4,3,2,3,4,5,4,5,6,7},
    new int[] {0,0,0,0,0,0},
    new int[] {0,0,0,0,0},
    new int[] {0,0,0},
    new int[] {0,0},
    new int[] {0,1,2,3,4},
    new int[] {0,1,2,3},
    new int[] {0,1,2},
    new int[] {0,-1,-2,-3,-4},
    new int[] {0,-1,-2,-3},
    new int[] {0,-1,-2}
};
            StartScreenView();

            while (gameRunning)
            {
                int random = rand.Next(0, streetelements.Length);
                removePlayerprevious(carPosition, streetwidth, carVelocity);
                moving(ref street, streetelements, random, streetwidth, roadwidth);
                view(roadwidth, street, streetwidth);
                movement(streetwidth, ref carVelocity, ref carPosition, ref gameRunning);
                Render(streetwidth, ref carPosition, ref carVelocity, gameRunning, ref previous);
                eveluateTheSituation(carPosition, street[street.Count - 1], street[street.Count - 1] + roadwidth - 1, ref gameRunning);
                Thread.Sleep(50);
                scorepoint = endScore(scorepoint);
            }
            if (!gameRunning)
            {

                endscreen(scorepoint, levelCompleted);
            }
            levelCompleted = levelcomplete(levelCompleted, scorepoint);
            score.LevelCompleted = levelCompleted;
            score.Level = level;
            score.Points = scorepoint;
            fin(level, levelBundary);
            return score;
        }

        private static void StartScreenView()
        {
            Console.Clear();
            Console.WriteLine("This is a driving game.");
            Console.WriteLine();
            Console.WriteLine("Stay on the road!");
            Console.WriteLine();
            Console.WriteLine("Use A, W or left and right arrows to control your car.");
            Console.WriteLine();
            Console.WriteLine("Press any buttom");
            Console.ReadKey();
            Console.Clear();

        }
        static void moving(ref List<int> list, int[][] elements, int random, int streetwidth, int roadwidth)
        {

            if (list.Count <= streetwidth)
            {
                for (int i = 0; i < elements[random].Length; i++)
                {
                    int newelement = elements[random][i] + list[i];
                    if (newelement > 0 && newelement + roadwidth < streetwidth)
                    {
                        list.Insert(0, newelement);
                    }

                }
            }
            list.RemoveAt(list.Count - 1);
        }
        static void view(int roadwidth, List<int> list, int streetwidth)
        {
            Console.Clear();
            for (int i = list.Count - streetwidth; i < list.Count; i++)
            {

                int lol = list[i] + roadwidth;
                for (int r = 0; r < list[i]; r++)
                {
                    Console.Write("-");
                }
                for (int k = 0; k < roadwidth; k++)
                {
                    Console.Write(" ");
                }
                for (int u = lol; u < streetwidth; u++)
                {
                    Console.Write("-");
                }
                Console.WriteLine();
            }
        }
        private static void Render(int streetwidth, ref int carPosition, ref int carVelocity, bool gameRunning, ref string previous)
        {
            Console.SetCursorPosition(carPosition, streetwidth - 1);

            if (gameRunning)
            {
                if (carVelocity < 0)
                {
                    //Console.Write("<");
                    previous = "<";
                }
                else if (carVelocity > 0)
                {
                    //Console.Write(">");
                    previous = ">";
                }

                Console.Write(previous);
            }
            else
            {
                Console.Write("X");
            }
            carPosition = Math.Max(0, Math.Min(streetwidth - 1, carPosition + carVelocity));
        }
        private static void movement(int streetwidth, ref int carVelocity, ref int carPosition, ref bool gameRunning)
        {
            if (Console.KeyAvailable)
            {
                ConsoleKey key = Console.ReadKey().Key;
                switch (key)
                {
                    case ConsoleKey.LeftArrow:
                        carVelocity = -1;
                        carPosition--;
                        break;
                    case ConsoleKey.RightArrow:
                        carVelocity = 1;
                        carPosition++;
                        break;
                    case ConsoleKey.A:
                        carVelocity = -1;
                        carPosition--;
                        break;
                    case ConsoleKey.D:
                        carVelocity = 1;
                        carPosition++;
                        break;
                    case ConsoleKey.Escape:
                        gameRunning = false;
                        break;
                    default:
                        carVelocity = 0;
                        break;
                }
            }
            else
            {
                carVelocity = 0;
            }
        }
        private static void eveluateTheSituation(int carPosition, int leftEdge, int rightEdge, ref bool gameRunning)
        {
            if (carPosition < leftEdge - 1 || carPosition > rightEdge + 1)
            {
                gameRunning = false;
            }
        }
        private static void endscreen(int scorepoint, bool levelcomplet)
        {
            Console.Clear();
            Console.WriteLine("Game Over, your score is " + scorepoint);

            if (levelcomplete(levelcomplet, scorepoint))
            {
                Console.WriteLine("You have completed the level");
            }
            else
            {
                Console.WriteLine("You haven't completed the level");
            }
            Console.WriteLine("Click any buttom to exit game");
            Console.ReadKey();

        }
        private static int endScore(int score)
        {
            score++;
            return score;
        }
        private static bool levelcomplete(bool levelcomplet, int score)
        {
            if (score >= 50)
            {
                levelcomplet = true;

            }
            else
            {
                levelcomplet = false;
            }
            return levelcomplet;
        }
        private static void removePlayerprevious(int carPosition, int streetwidth, int carVelocity)
        {
            if (carVelocity < 0)
            {
                Console.SetCursorPosition(carPosition + 1, streetwidth - 1);
                Console.Write(' ');
            }
            else if (carVelocity > 0)
            {
                Console.SetCursorPosition(carPosition - 1, streetwidth - 1);
                Console.Write(' ');
            }
            Console.SetCursorPosition(carPosition, streetwidth - 1);
        }
        private static void fin(int level, int[] levelBundary)
        {
            if (level >= 3 || level > levelBundary.Length)
            {
                throw new Exception();
            }
        }
    }
}
