﻿using System;
using System.Collections.Generic;
using System.Diagnostics;


namespace ConsoleGames.Games2024
{
    public class Labyrinth : Game
    {
        public override string Name => "Labyrinth"; // name of game, 'get' means: can be viewed publicly but not set
        public override string Description => "Entkomme dem Labyrinth so schnell wie möglich"; // short descripition of game
        public override string Rules => "Bewege dich mit WASD Erreiche die blaue Tür um das Level abzuschliessen umso schneller du bist umso besser wird q gedrückt wird das Spiel beendet"; // rules of game, how to play, exit
        public override string Credits => "Davide Testolin, datestol@ksr.ch"; // name(s) of author(s) incl. email
        public override int Year => 2024; // year in which game was created
        public override int LevelMax => 3; // max number of levels
        public override bool TheHigherTheBetter => false; // is a higher score desirable?
        public override Score HighScore { get; set; } // get; set means: can both be viewed and set publicly, don't touch this property, framework deals with it

        private int[] levelBundary = new int[] { 51, 101, 151, 201 };
        private int?[] maxAttempts = new int?[] { 7, 10, 15, null };
        public override Score Play(int level = 1)
        {
            Score score = new Score();
            string StartRoom = "";
            Random random = new Random();
            int DecideLevel = random.Next(1, 3);
            int[] levelsToChoose = new int[] { 1, 2, 3 };
            int levelNotChosen = 0;
            for (int i = 0; i < 3; i++)
            {
                if (level != levelsToChoose[i])
                {
                    levelNotChosen++;
                }
                if (levelNotChosen == 3)
                {
                    level = random.Next(1, 3);
                }
            }
            if (level == 1)
            {
                string Level1Point1 =
                  @"ooooooooooooooooooooooooooooodddooooooooooooooooooooooooooooz        
                  o...o................o...........................o.........oz
                  o...o............ooooo.ooooooooooooooooooooooooooo..o......oz
                  o...o.oooooooooooo...........................o......o......oz
                  o...o............oooooooooooooo..............o......o......oz
                  o...o............o...........................o....ooooooo..oz
                  o...ooooooooooo..oooooooooooooooooooo........o....o.....o..oz
                  o...o................................ooooooo.o....o.....o..oz
                  o...o....oooooooooooooooo.oo.........o.......o....o.....o..oz
                  o...o....o.................o.........o.ooooooo....o.....o..oz
                  o...o....o.................ooooo.....o.......o....o.....o..oz
                  o...o....o.....ooooooo.....ooooo....oooooooo.o....o.....o..oz
                  o.ooo....o.....o.....oo....o.........o.......o....o.....o..oz
                  o..o.....o.....o......o....ooo....oo.o.ooooooo..........o..oz 
                  o..o.....o.....o......oo...oooooooooo........oooooooo...o..oz
                  o..o.....o.....o........o...............................o..oz
                  o..o.....o.....o.........o.............oooooooooooooooo.o..oz
                  o..o.....ooooooo........ooooooooooooo........o..........o..oz
                  o..o..........o.........o............o.......o.oooooooooo..oz
                  o..o.....ooooooo........ooooooooooo.ooo......o..........o..oz
                  o..o...........o........o...........oo.......oooooooooo.o..oz
                  o..o....o......o........o.oooooooooooooooo...o..........o..oz
                  o..o..ooo......o........o...........o........o.oooooooooo..oz
                  o..o..oooooooooo........ooooooooooo.oooooooooo..........o..oz
                  o..o..o.................o...............................o..oz
                  o..o..ooooooooooooooooooo.oooooooooooooooooo.oooooooooo.o..oz
                  o.....o.........oop........................................oz
                  ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooz";

                string Level1point2 =
                    @"ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooz        
                  d...........o.......................o......................oz
                  oooooo......o............o..........o...........ooooooo....oz
                  o....o......ooooooooooo..o....ooooooo...............o.o....oz
                  o....o................o..o...............oooooooooooooo....oz
                  o....oooooooooooo.....o..o...............o.................oz
                  o...............o.....ooooooooooooooo....o.................oz
                  o...............o...................oooooo...oooooooo......oz
                  o.....ooooooooooooooooooooooooo.....o........o.....oo......oz
                  o.....o................o............o........o.....oo......oz
                  o.....o................o............o...oooooo.....oo......oz
                  o.....ooooooooooo......o...oooooooooo...o.oooo.............oz
                  o...........o...o......o................o....o.............oz
                  o...........o...o......o................oooo.o.............oz 
                  o......oooooo...o......ooooooooooooooo.oo....o.............oz
                  o......o........o.......................o..................oz
                  o......oooooo...o.................o.....oooooooooooooooo...oz
                  o...............oooooooooooooo....o.....o...........o..o...oz
                  o...............o............o....ooooooo.........o.o..o...oz
                  ooooooooooooooo.o............o..........o.........o........oz
                  o......o........o............o..........o.........ooooooooooz
                  o......o........o.....ooooooooooooo.....o..................oz
                  o......o...oooooo.................o.....o..................oz
                  o......o...o......................o.....ooooooooooooo......oz
                  o......o...o................o.....o........................oz
                  o......o...oooooooooo.......o.....o........................oz
                  o...................o.......o.....o.......................poz
                  ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooz";
                if (DecideLevel == 1)
                {
                    StartRoom = Level1Point1;
                }
                else
                {
                    StartRoom = Level1point2;
                }
            }
            if (level == 2)
            {
                string levelTwoPointOne =
                @"ooooooooooooooooooooooooooooodddooooooooooooooooooooooooooooz        
                  o.................o.o...............................o......oz
                  o..oooooooooooooo.o.o..ooo......oooooooooo.ooooooooooooooo.oz
                  o.o...............o.o..o........o.......................o.oz
                  o.o.ooooooooooooo.o.o..o...ooooooooooooooo.......oooo.oo.o.oz
                  o.o.o.............o.o..o...o.............o.......o..o..o.o.oz
                  o.o.o..oooooooooooo.o..o...ooo..oooooooo.oo.oooo.o..o..o.o.oz
                  o.o.o..o..........o....o.....o.........o.......o.o..o..o.o.oz
                  o.o.o..oooooooooooo.oooo.....ooooooooo.o.......o.o..o..o.o.oz
                  o.o.o..o.o..........o.....o..........o.oooooo.......oo.o.o.oz
                  o.o.o..o.o..........oooooooooooooooo.o...o..o..o....oo.o.o.oz
                  o.o.o..o.oooooooooo.o................o.o....o..o....oo.o.o.oz
                  o...o..o..........o.oooooooooooooooooo.oooooo..o....oo...o.oz
                  ooooo..oooooooo...o....................o.......o....oo.....oz 
                  o.............o...oooooooooooooooooo...o...ooo.o....oo.o.oooz
                  oooooo.oooooooo............o...........o...o.o.o....oo.o...oz
                  o...o..o...................o...............o.o.o....oo.o.o.oz
                  o.o.o..o.ooooo.oooooo......o...ooooooooooooo.o.o....oo.o.o.oz
                  o.o.o..o.......................o.............o.o....oo.o.o.oz
                  o.o.o..o.ooooooooooooooooooo...o.ooooooooooooo.o....oo.o.o.oz
                  o.o.o..o...................o...o...............o....oo.o.o.oz
                  o.o.o..ooooooooooooooooooo.o.o.ooooooooooooooooooooooo.o.o.oz
                  o.o.o......................o.o......................o..o.o.oz
                  o.o.oooooooooooooooooooooooo.ooooooooooooooooooooooooooo.o.oz
                  o.o........................o..........p..................o.oz
                  o.ooooooooooooooooooooooooooooooooooooooooooooooooooooooo..oz
                  o.................................o........................oz
                  ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooz";
                string levelTwoPointTwo =
                @"ooooooooooooooooooooooooooooodooooooooooooooooooooooooooooooz        
                  o........o...oooooooooooooooo.oooooo...............o.o.....oz
                  o.ooo....o...o.....................o........oooooooooo.o...oz
                  o...o....o...oooooooooooooooooooo..ooooooooooo.......o.o...oz
                  o.ooo....o...o.o...o...o...........o.........o.......o.o...oz
                  o...o....o...o.o.o.o.o.o..o........o..ooooo..o.......o.o...oz
                  ooo.o....o...o...o...o....o....ooooo..o...o..o.......o.o...oz
                  o.ooo....o...o.ooooooooooooooo.o..........o..o.........o...oz
                  o.o...oooo...o.o..o............o...oooooooo..ooooooooooo...oz
                  o.o......o...o.o..o............o...o...............o.......oz
                  o.....o......o.o..o...oooooooo.o..oo..........oooooooooo...oz
                  oooooooooo...o.o..o...o........o..o....oooooo.o....o.......oz
                  o........o...o.o..o...o..ooo...o..oooo.o......o....o.......oz
                  o.....oooo...o.o..o...o..o..o..o..............o....o...oooooz 
                  o........o...o.o..ooooo..o..o..o....oooooooo.oo....o.......oz
                  o.......oooooo.o............o..o....o..oo.....o...oooooo...oz
                  o....oooo....o.o......oooooooo.o.oooo...o.o.o.o........o...oz
                  o.......o.............o....ooo.o.o....o.o.o.o.o........o...oz
                  ooooo...ooooooooooooooo......o...o....o.o.o.o.o........o...oz
                  o...o.....o..............o.o.ooooo....o.o.o.o.ooooooo..o...oz
                  o...o.....o......oooooo..o.o.......o..o.ooo.o.......o..o...oz
                  o.........o......o....o..o.o.......o..o.....ooo.o...o..o...oz
                  o.........o.o.........o..o.o.ooo.oooooo.ooooo.o.o...o..o...oz
                  o.........oooooooooooooo.o.o.o.o.o..........o.o.o...o..o...oz
                  ooooooooo..o.............o.o.o.o.o...ooooo..o.o.o.o.o..o...oz
                  o......oo..o......o......o.ooo.ooo...o......o.o.ooo.oooo...oz
                  o......o...op.....o......o...........o..............o......oz
                  ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooz";
                if (DecideLevel == 1)
                {
                    StartRoom = levelTwoPointOne;
                }
                else
                {
                    StartRoom = levelTwoPointTwo;
                }
            }
            if (level == 3)
            {
                string Level3point1 =
                    @"ooooooooooooooooooooooooooooodddooooooooooooooooooooooooooooz        
                  o.o.................o...........o...o...............o......oz
                  o.o.o..ooooo........o..oooooooo...o...o.ooooooooooo.o.oooo.oz
                  o.o.o....o.....oooooo......o..o.......o.o.........o.o.o....oz
                  o.o.o....o.........o....o.....o....oooooooooooo.oooooooooo.oz
                  o.o.oooo.o.ooooooooo..oooooo..o.....................o.o....oz
                  o...o..o.o.o.......o..oo.oo...ooooooooooooo....ooooooooooo.oz
                  ooooo..o.o.o.......o..o..o...o...o...o....o.....o........o.oz
                  o.o....o.o.ooooooo.o.oo....o...o...o...o..o.....o..oooo..o.oz
                  o.o..o.o.o.......o.o.oooooo..oooooooooooo.o.....o..oo.o..o.oz
                  o.o..o...o..oooo.o.o........oo............ooooooo..o..o....oz
                  o.o..ooooo...o.o.o.ooooooo..oo...oooooo............oo...ooooz
                  o.o..........o.o.o.......o..oo...o....oooo.oooooooooo......oz
                  o.oooooo.o.ooo.o.o.......o..oo...o..................oooooo.oz 
                  o......o.o.o...o.o..ooo..oo.oo.ooooo.oooooooooo.....o....o.oz
                  oooooo.o.o.oo.oooo..o.ooo.o....o...o.o........oooooooooooo.oz
                  o....o.o.oooo.o.....o.....o....o.ooo.o.o.oooo.o............oz
                  o.o..o........o.ooo.oooo..oooo.o.....o.o....o...oooooooooo.oz
                  o.o..oooooooooo.o.o....o.....o.ooooooo.o.oooo.ooo...o....o.oz
                  o.o..o.o........o.o....o.....ooo.......o........oooooooo.o.oz
                  o.o.oo.o........o.oooo.o.........oooo..ooooooooooooooooo.o.oz
                  o.o.o...........o....o.o.oooo....o..o...............o....o.oz
                  o.o.ooooooo...ooooo..o.ooo..o....o..o.oooooo.oo.o.oooooooo.oz
                  o.o.o...ooo...o...o..o......o....o..o.oooooo.o..o.o.o......oz
                  o.o.o..ooo....o.o....o.oooo.op...o..o......o.o..o...o...o..oz
                  o.oooooo...oo.o.oooooo.o..o.oooooo..oooooooo.oo.ooo.ooooo..oz
                  o......opooo..o........o............................o......oz
                  ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooz";

                string Level3point2 =
                    @"ooooooooooooooooooooooooooooodooooooooooooooooooooooooooooooz        
                  o...........o...........o.............o............oo......oz
                  o.ooo....oooo...oooooo..ooo....oooooooo......ooooo.oooooo..oz
                  o.o.........o.ooo..ooo.........o.................o.ooo..o..oz
                  o.ooooooooooo......o...........ooooooooooooooooooo.ooo..o..oz
                  o.o.....o...oooooooooooooooooo...........o.........ooo..o..oz
                  o.o.o.ooo.....o....................ooooo.o.......o.ooo..o..oz
                  o.o.o.o.......o.ooooooo......ooooooo.....o.......o.ooo..o..oz
                  o.o.o.o.o.....o.o.....oooooooo.....o.ooooooooooooo...o..o..oz
                  o.o.o.o.o.....o.o.ooooo.ooooo......o.............o...oooo..oz
                  o.o.o.ooo.....o.o.o.......o........ooooooooooooo.o....o....oz
                  o.o.o...o.....o.o.o....oooo.oooo...............o.ooo..o..o.oz
                  o.o.o.o.o.....o.o.o....o....o..oo....ooo.ooooo.o.o....o..o.oz
                  o.o.ooo.......o.o.o....o.oooo...o....o.o.....o.o.o.oooo..o.oz 
                  o.o...........o.o......o....ooo.o....o.o.....o.o.o....oo.o.oz
                  o...ooooooooooo.ooooooooooo...o.oooooo.ooo...o.o.......o.o.oz
                  ooooo.o....o..............o...o..........o...o.o..oooo.o.o.oz
                  o.o...o..oooooo.....o.....o...oooooooo.o.ooo.o.oooo..o.o.o.oz
                  o.o...o..o....o.....o.....o............o.............o.o.o.oz
                  o.o...o..o....ooooooo.....oooooooooooo.o..oooooo.oo..o.o.o.oz
                  o.o......o..o.......o.....o............o......o...o..o.o.o.oz
                  o.o.oooooo..o.......o.....o...oooooooooo......o...o..o.ooo.oz  
                  ooo.o...o...o....oooooooooo...o...............o...o..o.....oz
                  o.p...o...oooooo.....o........o........oooooooo...o..oooo..oz
                  oooooooooooooo.o.....o...o....o........o..........o..o..o..oz
                  o.o...o....o.o.o.....o...o....oooooooooo.....oooo.ooooooo..oz
                  o...o....o.....o.........o.................................oz
                  ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooz";
                if (DecideLevel == 1)
                {
                    StartRoom = Level3point1;
                }
                else
                {
                    StartRoom = Level3point2;
                }
            }
            score.LevelCompleted = false;
            score.Points = 999999;
            Console.CursorVisible = false;
            bool levelCompleted = false;
            int[] posPlayer = new int[] { 60, 14 };
            List<int> KoordinatenObjekte = new List<int>();
            int[] removePos = new int[] { };
            Stopwatch stopwatch = Stopwatch.StartNew();
            bool notWon = true;
            List<int> DoorFound = new List<int> { };
            List<int> FoundPlayer = new List<int> { };
            List<int> FoundEnemy = new List<int>();
            double timeForEnemy = 0.5;
            int Check = 0;
            KoordinatenObjekte = LearnToDraw(StartRoom, KoordinatenObjekte);
            DoorFound = findDoor(StartRoom, DoorFound);
            FoundPlayer = findPlayer(StartRoom, FoundPlayer);
            FoundEnemy = findEnemy(StartRoom, FoundEnemy);
            while (notWon)
            {
                removePos = NewPlayerPos(posPlayer, removePos, FoundPlayer, Check);
                Check++;
                posPlayer = MovePlayer(removePos, KoordinatenObjekte);
                if (posPlayer[0] == 999)
                {
                    break;
                }
                notWon = CheckIfPlayerHasWon(DoorFound, posPlayer);
                long Zeit = stopwatch.ElapsedMilliseconds;
                if (Zeit > timeForEnemy)
                {
                    timeForEnemy += 1;
                    FoundEnemy = MoveEnemys(FoundEnemy, KoordinatenObjekte, posPlayer, DoorFound);
                }
            }
            if (notWon == false)
            {
                long time = stopwatch.ElapsedMilliseconds;
                time = time / 1000;
                levelCompleted = true;
                Console.BackgroundColor = ConsoleColor.Black;
                Console.ForegroundColor = ConsoleColor.White;
                score.LevelCompleted = levelCompleted;
                score.Level = level;
                score.Points = Convert.ToInt32(time);
                return score;
            }
            else
            {
                Console.BackgroundColor = ConsoleColor.Black;
                Console.ForegroundColor = ConsoleColor.White;
                score.LevelCompleted = false;
                score.Level = level;
                score.Points = 99999;
                return score;
            }

        }
        public static List<int> MoveEnemys(List<int> FoundEnemy, List<int> KoordinatenObjekte, int[] posPlayer, List<int> DoorFound)
        {
            return FoundEnemy;
            //       üüü
            //       üeü
            //       üüü
            //wird zur Benutzung bei einem Gegner gerade gemacht
            int[] activeGrid = new int[] { };
            for (int i = 0; i < FoundEnemy.Count; i++)
            {
                activeGrid[i] = FoundEnemy[i];
            }
        }
        public static List<int> findEnemy(string StartRoom, List<int> EnemyFound)
        {
            string Instructions = "z.pdoe";
            int x = 0;
            int y = 0;

            for (int b = 0; b < StartRoom.Length; b++)
            {
                int oldX = x;
                if (StartRoom[b] == Instructions[0])
                {
                    y++;
                    x = 0;
                }
                if (StartRoom[b] == Instructions[1])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[5])
                {
                    Console.BackgroundColor = ConsoleColor.Cyan;
                    Console.ForegroundColor = ConsoleColor.Cyan;
                    EnemyFound.Add(x);
                    EnemyFound.Add(y);
                    Console.SetCursorPosition(x, y);
                    Console.WriteLine("DT");
                    x += 2;
                }
                if (StartRoom[b] == Instructions[3])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[4])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[2])
                {
                    x += 2;
                }
            }
            return EnemyFound;
        }
        public static List<int> findPlayer(string StartRoom, List<int> FoundPlayer)
        {
            string Instructions = "z.pdoe";
            int x = 0;
            int y = 0;

            for (int b = 0; b < StartRoom.Length; b++)
            {
                int oldX = x;
                if (StartRoom[b] == Instructions[0])
                {
                    y++;
                    x = 0;
                }
                if (StartRoom[b] == Instructions[1])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[2])
                {
                    Console.BackgroundColor = ConsoleColor.Cyan;
                    Console.ForegroundColor = ConsoleColor.Cyan;
                    FoundPlayer.Add(x);
                    FoundPlayer.Add(y);
                    Console.SetCursorPosition(x, y);
                    Console.WriteLine("DT");
                    x += 2;
                }
                if (StartRoom[b] == Instructions[3])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[4])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[5])
                {
                    x += 2;
                }
            }
            return FoundPlayer;
        }
        public static List<int> findDoor(string StartRoom, List<int> DoorFound)
        {
            string Instructions = "z.dpoe";
            int x = 0;
            int y = 0;

            for (int b = 0; b < StartRoom.Length; b++)
            {
                int oldX = x;
                if (StartRoom[b] == Instructions[0])
                {
                    y++;
                    x = 0;
                }
                if (StartRoom[b] == Instructions[1])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[2])
                {
                    Console.BackgroundColor = ConsoleColor.Blue;
                    Console.ForegroundColor = ConsoleColor.Blue;
                    DoorFound.Add(x);
                    DoorFound.Add(y);
                    Console.SetCursorPosition(x, y);
                    Console.Write("DT");
                    x += 2;
                }
                if (StartRoom[b] == Instructions[3])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[4])
                {
                    x += 2;
                }
                if (StartRoom[b] == Instructions[5])
                {
                    x += 2;
                }
            }
            return DoorFound;
        }
        public static bool CheckIfPlayerHasWon(List<int> DoorFound, int[] playerPos)
        {
            int Counter = DoorFound.Count;
            for (int i = 0; i < Counter; i += 2)
            {
                if (playerPos[0] == DoorFound[i])
                {
                    if (playerPos[1] == DoorFound[i + 1])
                    {
                        return false;
                    }
                }
            }
            return true;
        }
        public static int[] NewPlayerPos(int[] newPosPlayer, int[] removePos, List<int> PlayerFound, int Check)
        {
            if (Check == 0)
            {
                Console.SetCursorPosition(PlayerFound[0], PlayerFound[1]);
                Console.BackgroundColor = ConsoleColor.Cyan;
                Console.ForegroundColor = ConsoleColor.Cyan;
                Console.WriteLine("DT");
                newPosPlayer[0] = PlayerFound[0];
                newPosPlayer[1] = PlayerFound[1];
                return newPosPlayer;
            }
            Console.SetCursorPosition(removePos[0], removePos[1]);
            Console.BackgroundColor = ConsoleColor.Black;
            Console.ForegroundColor = ConsoleColor.Black;
            Console.WriteLine("DT");
            Console.BackgroundColor = ConsoleColor.Cyan;
            Console.ForegroundColor = ConsoleColor.Cyan;
            Console.SetCursorPosition(newPosPlayer[0], newPosPlayer[1]);
            Console.WriteLine("DT");
            return newPosPlayer;
        }
        public static int[] MovePlayer(int[] oldPosPlayer, List<int> KoordinatenObjekte)
        {
            string inputGiven = "";
            string allowedInputs = "wasd";
            int[] newPosPlayer = new int[] { 0, 0 };
            ConsoleKeyInfo ab = Console.ReadKey(true);     //die gedrückte Taste wird gelesen und angeschaut   füge true hinzu zum verstecken                                              
            inputGiven = Convert.ToString(ab.KeyChar);
            int falseInput = 0;


            if (ab.Key == ConsoleKey.Q)
            {
                return new int[] { 999 };
            }
            for (int k = 0; k < allowedInputs.Length; k++)
            {
                if (allowedInputs[k] != inputGiven[0])
                {
                    falseInput++;
                }
                if (falseInput == 4)
                {
                    return oldPosPlayer;
                }
            }
            int counter = KoordinatenObjekte.Count;
            if (ab.Key == ConsoleKey.A)
            {
                newPosPlayer[0] = oldPosPlayer[0];
                newPosPlayer[0] += -2;
                newPosPlayer[1] = oldPosPlayer[1];
                for (int i = 0; i < counter; i++)
                {
                    if (newPosPlayer[0] == KoordinatenObjekte[i])
                    {
                        if (newPosPlayer[1] == KoordinatenObjekte[i + 1])
                        {
                            return oldPosPlayer;
                        }
                    }
                }
                return newPosPlayer;
            }
            if (ab.Key == ConsoleKey.W)
            {
                newPosPlayer[0] = oldPosPlayer[0];
                newPosPlayer[1] = oldPosPlayer[1];
                newPosPlayer[1] += -1;
                for (int i = 0; i < counter; i++)
                {
                    if (newPosPlayer[0] == KoordinatenObjekte[i])
                    {
                        if (newPosPlayer[1] == KoordinatenObjekte[i + 1])
                        {
                            return oldPosPlayer;
                        }
                    }
                }
                return newPosPlayer;
            }
            if (ab.Key == ConsoleKey.S)
            {
                newPosPlayer[0] = oldPosPlayer[0];
                newPosPlayer[1] = oldPosPlayer[1];
                newPosPlayer[1] += 1;
                for (int i = 0; i < counter; i++)
                {
                    if (newPosPlayer[0] == KoordinatenObjekte[i])
                    {
                        if (newPosPlayer[1] == KoordinatenObjekte[i + 1])
                        {
                            return oldPosPlayer;
                        }
                    }
                }
                return newPosPlayer;
            }
            if (ab.Key == ConsoleKey.D)
            {
                newPosPlayer[0] = oldPosPlayer[0];
                newPosPlayer[0] += 2;
                newPosPlayer[1] = oldPosPlayer[1];
                for (int i = 0; i < counter; i++)
                {
                    if (newPosPlayer[0] == KoordinatenObjekte[i])
                    {
                        if (newPosPlayer[1] == KoordinatenObjekte[i + 1])
                        {
                            return oldPosPlayer;
                        }
                    }
                }
                return newPosPlayer;
            }
            return newPosPlayer;
        }
        public static List<int> LearnToDraw(string StartRoom, List<int> KoordinatenObjekte)
        {
            string instructionsAvailable = "z.odp";
            int i = 0;
            int x = 0;
            int y = 0;

            for (int b = 0; b < StartRoom.Length; b++)
            {
                int oldX = x;
                if (StartRoom[b] == instructionsAvailable[0])
                {
                    y++;
                    x = 0;
                }
                if (StartRoom[b] == instructionsAvailable[1])
                {
                    x += 2;
                }
                if (StartRoom[b] == instructionsAvailable[2])
                {
                    KoordinatenObjekte.Add(x);
                    KoordinatenObjekte.Add(y);
                    Console.BackgroundColor = ConsoleColor.Gray;
                    Console.ForegroundColor = ConsoleColor.Gray;
                    Console.SetCursorPosition(x, y);
                    Console.Write("DT");
                    x += 2;
                }
                if (StartRoom[b] == instructionsAvailable[3])
                {
                    x += 2;
                }
                if (StartRoom[b] == instructionsAvailable[4])
                {
                    x += 2;
                }
            }
            return KoordinatenObjekte;
        }
    }
}