﻿using System;
using System.Collections.Generic;

namespace ConsoleGames.Games2024
{
    public class SimonSays : Game
    {
        public override string Name => "Simon Says";
        public override string Description => "The nine squares right in front of you will change their colours in a random order. \nThe score depends on your level progress.";
        public override string Rules => "Repeat the order of the colour RED, and ONLY RED. \nRepeat the order with the numbers on your keyboard. \nThe top left square is number 1, top middle square is number 2 and so on. \nYou have 3 lives per level. \nEnter ONE NUMBER per line and press ENTER after each number.";
        public override string Credits => "Luan-Nebi Zendeli, luzendel@ksr.ch";
        public override int Year => 2024;
        public override bool TheHigherTheBetter => true;
        public override int LevelMax => 3;
        public override Score HighScore { get; set; }
        public override Score Play(int level = 1)
        {
            Score score = new Score();
            score.LevelCompleted = false;
            List<int> ColourOrder = new List<int>(); //Soloution
            int differentColour = 0;
            int amountShown = 0; //Amount of red squares shown
            int amountOfColours = 0; //Amount of red squares which needs to be shown 
            int maxColours = 0; //Limit of "amountOfColours"
            int lives = 3;
            int points = 0;
            int originalLives = 3;
            int randomNumber = 0;
            int randomFalseNumber = 0;
            List<int> PlayerInput = new List<int>();
            if (level == 1)
            {
                differentColour = 0;
                amountOfColours = 3;
                maxColours = 5;
            }
            else if (level == 2)
            {
                differentColour = 25; //Possibility of a different colour appearing (25% in this case)
                amountOfColours = 3;
                maxColours = 6;
            }
            else if (level == 3)
            {
                differentColour = 50;
                amountOfColours = 3;
                maxColours = 7;
            }
            while (true)
            {
                Map();
                while (amountOfColours > amountShown)
                {
                    RandomColour(ref randomNumber, ref differentColour, ref randomFalseNumber);
                    System.Threading.Thread.Sleep(500);
                    if (randomNumber != 0)
                    {
                        ColourOrder.Add(randomNumber);
                        amountShown++;
                    }
                    CleanColour(ref randomNumber, ref randomFalseNumber);
                    System.Threading.Thread.Sleep(500);
                }
                Map();
                InputTime(ref amountOfColours, PlayerInput);
                CheckInputs(ColourOrder, PlayerInput, ref lives, ref amountOfColours, ref maxColours);
                if (originalLives == lives && amountOfColours <= maxColours)
                {
                    System.Threading.Thread.Sleep(3000);
                    amountShown = 0;
                    PlayerInput.Clear();
                    ColourOrder.Clear();
                    points++;
                    continue;
                }
                else if (lives != 0 && amountOfColours >= maxColours && lives == originalLives)
                {
                    System.Threading.Thread.Sleep(3000);
                    points++;
                    score.LevelCompleted = true;
                    break;
                }
                else if (lives != 0 && lives != 3 && lives != originalLives)
                {
                    System.Threading.Thread.Sleep(3000);
                    originalLives--;
                    amountShown = 0;
                    PlayerInput.Clear();
                    ColourOrder.Clear();
                    continue;
                }
                else
                {
                    System.Threading.Thread.Sleep(3000);
                    break;
                }
            }
            score.Level = level;
            score.Points = points;
            return score;
        }
        private void Map()
        {
            Console.Clear();
            int cellWidthX = 10;
            int cellWidthY = 6;
            int wholeLineX = cellWidthX * 3;
            int wholeLineY = cellWidthY * 3;
            for (int i = 0; i < wholeLineX; i++)
            {
                Console.SetCursorPosition(i, 0);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            for (int i = 0; i < wholeLineX; i++)
            {
                Console.SetCursorPosition(i, cellWidthY);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            for (int i = 0; i < wholeLineX; i++)
            {
                Console.SetCursorPosition(i, 2 * cellWidthY);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            for (int i = 0; i < wholeLineX; i++)
            {
                Console.SetCursorPosition(i, 3 * cellWidthY);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            for (int i = 0; i < wholeLineY; i++)
            {
                Console.SetCursorPosition(0, i);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            for (int i = 0; i < wholeLineY; i++)
            {
                Console.SetCursorPosition(cellWidthX, i);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            for (int i = 0; i < wholeLineY; i++)
            {
                Console.SetCursorPosition(cellWidthX * 2, i);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            for (int i = 0; i < wholeLineY + 1; i++)
            {
                Console.SetCursorPosition(cellWidthX * 3, i);
                Console.BackgroundColor = ConsoleColor.White;
                Console.ForegroundColor = ConsoleColor.White;
                Console.Write("-");

            }
            Console.BackgroundColor = ConsoleColor.Black;
            Console.ForegroundColor = ConsoleColor.White;
        }
        private int RandomColour(ref int randomSquare, ref int theDifferentColour, ref int randomFalseSquare)
        {
            randomSquare = 0;
            randomFalseSquare = 0;
            Random rand = new Random();
            int RightOrWrongColour = rand.Next(1, 100);
            if (RightOrWrongColour > theDifferentColour)
            {
                randomSquare = rand.Next(1, 9);
                if (randomSquare == 1)
                {
                    ColorMachine3000(1, 6, 1, 10, ConsoleColor.Red);
                }
                else if (randomSquare == 2)
                {
                    ColorMachine3000(1, 6, 11, 20, ConsoleColor.Red);
                }
                else if (randomSquare == 3)
                {
                    ColorMachine3000(1, 6, 21, 30, ConsoleColor.Red);
                }
                else if (randomSquare == 4)
                {
                    ColorMachine3000(7, 12, 1, 10, ConsoleColor.Red);
                }
                else if (randomSquare == 5)
                {
                    ColorMachine3000(7, 12, 11, 20, ConsoleColor.Red);
                }
                else if (randomSquare == 6)
                {
                    ColorMachine3000(7, 12, 21, 30, ConsoleColor.Red);
                }
                else if (randomSquare == 7)
                {
                    ColorMachine3000(13, 18, 1, 10, ConsoleColor.Red);
                }
                else if (randomSquare == 8)
                {
                    ColorMachine3000(13, 18, 11, 20, ConsoleColor.Red);
                }
                else
                {
                    ColorMachine3000(13, 18, 21, 30, ConsoleColor.Red);
                }
                return randomSquare;
            }
            else
            {
                randomFalseSquare = rand.Next(1, 9);
                if (randomFalseSquare == 1)
                {
                    ColorMachine3000(1, 6, 1, 10, ConsoleColor.Blue);
                }
                else if (randomFalseSquare == 2)
                {
                    ColorMachine3000(1, 6, 11, 20, ConsoleColor.Green);
                }
                else if (randomFalseSquare == 3)
                {
                    ColorMachine3000(1, 6, 21, 30, ConsoleColor.Magenta);
                }
                else if (randomFalseSquare == 4)
                {
                    ColorMachine3000(7, 12, 1, 10, ConsoleColor.Cyan);
                }
                else if (randomFalseSquare == 5)
                {
                    ColorMachine3000(7, 12, 11, 20, ConsoleColor.Gray);
                }
                else if (randomFalseSquare == 6)
                {
                    ColorMachine3000(7, 12, 21, 30, ConsoleColor.Yellow);
                }
                else if (randomFalseSquare == 7)
                {
                    ColorMachine3000(13, 18, 1, 10, ConsoleColor.DarkBlue);
                }
                else if (randomFalseSquare == 8)
                {
                    ColorMachine3000(13, 18, 11, 20, ConsoleColor.DarkYellow);
                }
                else
                {
                    ColorMachine3000(13, 18, 21, 30, ConsoleColor.DarkGreen);
                }
                return randomFalseSquare;
            }
        }
        private List<int> InputTime(ref int theAmountOfColours, List<int> PlayersInput)
        {
            Console.SetCursorPosition(0, 20);
            Console.WriteLine("Repeat the Order of the Colour Red!");
            for (int i = 0; i < theAmountOfColours; i++)
            {
                try
                {
                    int answer = Convert.ToInt32(Console.ReadLine());
                    PlayersInput.Add(answer);
                }
                catch (Exception)
                {
                    Console.Clear();
                    Map();
                    Console.SetCursorPosition(0, 20);
                    Console.WriteLine("Invalid Input");
                    i = -1;
                    PlayersInput.Clear();
                    continue;
                }
            }
            return PlayersInput;
        }
        private int CheckInputs(List<int> Solution, List<int> PlayersSolution, ref int livesLeft, ref int theAmount, ref int theMax)
        {
            for (int i = 0; i < Solution.Count; i++)
            {
                if (Solution[i] != PlayersSolution[i])
                {
                    livesLeft--;
                    Console.Clear();
                    if (livesLeft == 0)
                    {
                        Console.WriteLine("Game Over! You failed!");
                        return livesLeft;
                    }
                    else
                    {
                        Console.WriteLine("Wrong! Lives left: " + livesLeft);
                        return livesLeft;
                    }
                }
            }
            Console.Clear();
            theAmount++;
            if (theAmount <= theMax)
            {
                Console.WriteLine("Good Job! Keep it up!");
            }
            else if (theAmount >= theMax)
            {
                Console.WriteLine("Congratulations! Level Completed!");
            }
            return livesLeft;
        }
        private void CleanColour(ref int randomSquare, ref int randomFalseSquare)
        {
            if (randomSquare == 1 || randomFalseSquare == 1)
            {
                ColorMachine3000(1, 6, 1, 10, ConsoleColor.Black);
            }
            else if (randomSquare == 2 || randomFalseSquare == 2)
            {
                ColorMachine3000(1, 6, 11, 20, ConsoleColor.Black);
            }
            else if (randomSquare == 3 || randomFalseSquare == 3)
            {
                ColorMachine3000(1, 6, 21, 30, ConsoleColor.Black);
            }
            else if (randomSquare == 4 || randomFalseSquare == 4)
            {
                ColorMachine3000(7, 12, 1, 10, ConsoleColor.Black);
            }
            else if (randomSquare == 5 || randomFalseSquare == 5)
            {
                ColorMachine3000(7, 12, 11, 20, ConsoleColor.Black);
            }
            else if (randomSquare == 6 || randomFalseSquare == 6)
            {
                ColorMachine3000(7, 12, 21, 30, ConsoleColor.Black);
            }
            else if (randomSquare == 7 || randomFalseSquare == 7)
            {
                ColorMachine3000(13, 18, 1, 10, ConsoleColor.Black);
            }
            else if (randomSquare == 8 || randomFalseSquare == 8)
            {
                ColorMachine3000(13, 18, 11, 20, ConsoleColor.Black);
            }
            else
            {
                ColorMachine3000(13, 18, 21, 30, ConsoleColor.Black);
            }
        }
        private void ColorMachine3000(int value0, int value1, int value2, int value3, ConsoleColor value4)
        {
            for (int i = value0; i < value1; i++)
            {
                for (int z = value2; z < value3; z++)
                {
                    Console.SetCursorPosition(z, i);
                    Console.BackgroundColor = value4;
                    Console.ForegroundColor = value4;
                    Console.Write("-");
                }
            }
        }
    }
}