﻿using System;
using System.Threading;

namespace ConsoleGames.Games2024
{
    public class Battle : Game
    {
        //---------------------------------------------------//
        // PUBLIC PROPERTIES (Eigenschaften)
        //---------------------------------------------------//

        public override string Name => "Mall Experience";

        public override string Description => "This is a turn-based battle game";


        public override string Rules => "Das Spiel ist auf Englisch. Mit defense hast du eine 1%ige Chance um wieder ganz gehealed zu werden. Ansonsten gibt es nichts spezielles was du wissen musst.";


        public override string Credits => "Hamza Skenderi";


        public override int Year => 2023;


        public override int LevelMax => 4;


        public override bool TheHigherTheBetter => false;

        public override Score HighScore { get; set; }

        // NO additional public properties allowed, all additional ones must be private

        //---------------------------------------------------//

        // PRIVATE FIELDS
        // here write your private fields

        private int[] levelStartingPlayerHP = new int[] { 40, 65, 90, 130 };
        private int[] levelStartingPlayerAP = new int[] { 5, 8, 11, 16 };
        private int[] levelStartingPlayerMP = new int[] { 10, 16, 30, 30 };
        private int[] levelStartingPlayerVER = new int[] { 3, 5, 7, 10 };
        private int[] levelStartingPlayerMA = new int[] { 7, 10, 13, 19 };
        private int[] levelStartingPlayerHeal = new int[] { 5, 5, 7, 14 };
        private int[] levelStartingEnemyHP = new int[] { 30, 60, 120, 155 };
        private int[] levelStartingEnemyAP = new int[] { 3, 9, 11, 15 };
        private int[] levelStartingEnemyMP = new int[] { 1, 1, 3, 5 };
        private int[] levelStartingEnemyHeal = new int[] { 3, 5, 7, 6 };

        private int[] ManaPotionsperLevel = new int[] { 1, 2, 2, 2 };
        private int[] HealthPotionsperLevel = new int[] { 1, 2, 3, 4 };
        private int[] ManaPotionsWert = new int[] { 5, 5, 10, 10 };
        private int[] HealthPotionsWert = new int[] { 5, 5, 11, 17 };

        //---------------------------------------------------//
        // PUBLIC METHODS
        //---------------------------------------------------//

        /// <summary>
        /// Public method <c>Play</c> that is called by framework (in Program.cs) to start the game.
        /// </summary>
        /// <remarks>
        /// If player is not successful (fail or quit), set score.points=-1.
        /// If sucessfull, score.points is positive int representing score achieved
        /// </remarks>
        /// <param name="level">the level of the game</param>
        /// <returns>
        /// Score object that contains info about score achieved.
        /// </returns>

        public override Score Play(int level = 1)
        {
            Score score = new Score();
            score.LevelCompleted = false;
            score.Level = level;
            if (level > LevelMax) level = LevelMax;

            Random rnd = new Random();

            int HealthPotionsLeft = ManaPotionsperLevel[level - 1];
            int ManaPotionsLeft = HealthPotionsperLevel[level - 1];

            int level4Heal = 0;

            int playerhp = levelStartingPlayerHP[level - 1];
            int enemyhp = levelStartingEnemyHP[level - 1];

            int playerDefense = levelStartingPlayerVER[level - 1];

            bool isDefending = false;
            bool isDefenseMagic = false;
            bool isAttackMagic = false;

            int manapoints = levelStartingPlayerMP[level - 1];
            int magicattack = levelStartingPlayerMA[level - 1];

            int playerattack = levelStartingPlayerAP[level - 1];
            int enemyattack = levelStartingEnemyAP[level - 1];

            int enemymanapoints = levelStartingEnemyMP[level - 1];
            int enemymagicattack = enemyattack * 3;

            int playerheal = levelStartingPlayerHeal[level - 1];
            int enemyheal = levelStartingEnemyHeal[level - 1];

            int PlayerAttackCount = 0;
            int NeededPlayerAttackCount = rnd.Next(5, 6);

            int DefenseMagicCounter = 0;
            int AttackMagicCounter = 0;

            Intro(level);

            if (level == 5)
            {
                Console.WriteLine("Digga, wie häsch da gschafft?");
                Environment.Exit(0);
            }

            BeginningDialog(level);
            while (playerhp > 0 && enemyhp > 0)
            {
                ShowStats(ref playerhp, ref enemyhp, ref manapoints);

                PlayerTurn(ref playerhp, ref playerattack, playerheal, ref enemyhp, enemyattack, ref manapoints, magicattack, ref PlayerAttackCount, ref playerDefense, ref isDefending, ref isDefenseMagic, ref HealthPotionsLeft, ref ManaPotionsLeft, ref isAttackMagic, level, ref AttackMagicCounter, ref DefenseMagicCounter, levelStartingPlayerHP, ref HealthPotionsWert, ref ManaPotionsWert);

                if (enemyhp <= 0)
                {
                    score.LevelCompleted = true;
                    score.Level = level;
                    Console.WriteLine("You won");
                    if (level == 4)
                    {
                        Console.Clear();
                        EndingDialog(level);
                    }
                    Thread.Sleep(3000);
                    break;
                }

                ShowStats(ref playerhp, ref enemyhp, ref manapoints);
                Thread.Sleep(2000);

                EnemyTurn(ref enemyhp, enemyattack, enemyheal, ref playerhp, ref playerattack, ref enemymagicattack, ref enemymanapoints, ref PlayerAttackCount, NeededPlayerAttackCount, playerDefense, ref isDefending, ref isDefenseMagic, ref isAttackMagic, level, ref level4Heal);

                if (playerhp <= 0)
                {
                    Console.WriteLine("You lost");
                    Thread.Sleep(3000);
                    break;
                }

                ShowStats(ref playerhp, ref enemyhp, ref manapoints);

                Console.ReadKey();

                Console.Clear();
            }
            score.Points = 1;
            return score;
        }

        private static void Intro(int level)
        {
            if (level == 1)
            {
                Console.WriteLine("Before playing this I recommend reading the rules first. Thank you for playing.");
                Thread.Sleep(3000);
                Console.ReadKey();
                Console.Clear();
            }
            else
            {
                Console.Clear();
            }
        }

        private static void BeginningDialog(int level)
        {
            Console.WriteLine("press any key");
            Console.ReadKey();
            Console.Clear();

            if (level == 1)
            {
                Console.WriteLine("You are in the mall and you see cornflakes.");
                Console.ReadKey(true);
                Console.WriteLine("You go to the supermarket shelf and want to get the cornflakes.");
                Console.ReadKey(true);
                Console.WriteLine("But a little kid is there. He saw that you were on your way to get the cornflakes, but he wanted to overtake you.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: Hey kiddo. That's my Cornflakes");
                Console.ReadKey(true);
                Console.WriteLine("LITTLE KID: HAHAHAHAHAHAHA. Shut up. They're mine now");
                Console.ReadKey(true);
                Console.WriteLine("YOU: A'ight. Bet.");
                Console.ReadKey(true);
            }

            if (level == 2)
            {
                Console.WriteLine("LITTLE KID: BUUUUUAAAAAAAAHHHH. I CAN'T BELIEVE YOU ACTUALLY BEAT ME UP.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: The game is the game kiddo.");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: HOW COULD YOU, YOU MONSTER.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: I'm sorry. He tried to set me up.");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: BUT HE'S LITERALLY THREE YEARS OLD.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: What do you want to do now? Beat me up?");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: No");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: I want to end you.");
                Console.ReadKey(true);
                Console.WriteLine("PS: The pronouns for the mother are he/him");
                Console.ReadKey(true);
            }

            if (level == 3)
            {
                Console.WriteLine("SECURITY GUARD: Hey, what is happening here.");
                Console.ReadKey(true);
                Console.WriteLine("LITTLE KID: He literally beat me up.");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: damn");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: where is your mother?");
                Console.ReadKey(true);
                Console.WriteLine("LITTLE KID: She tries to fight that guy. She pulled out her pepper spray. The guy somehow doesn't feel any pain.");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: Why did he beat you up exactly?");
                Console.ReadKey(true);
                Console.WriteLine("LITTLE KID: I wanted to get cornflakes.");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: oh");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: HEY YOU.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: I told you, you had no chance.");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: but..., but... how?");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: COME HERE AND FIGHT WITH SOMEONE YOUR SIZE.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: remember...");
                Console.ReadKey(true);
                Console.WriteLine("YOU: you asked for it...");
                Console.ReadKey(true);
            }

            if (level == 4)
            {
                Console.WriteLine("SECURITY GUARD: I just can't believe it.");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: You're just too strong.");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: I have...");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: I have to call him.");
                Console.ReadKey(true);
                Console.WriteLine("LITTLE KID: Yeah, that's a good idea mom.");
                Console.ReadKey(true);
                Console.WriteLine("SECURITY GUARD: But who do you mean?");
                Console.ReadKey(true);
                Console.WriteLine("You hear big steps approaching you.");
                Console.ReadKey(true);
                Console.WriteLine("???: You don't have to call me.");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: Thank god.");
                Console.ReadKey(true);
                Console.WriteLine("LITTLE KID: DADA, YEEEEAAAAAH. BEAT HIM UP. BEAT HIM UP.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: So you want it too?");
                Console.ReadKey(true);
                Console.WriteLine("FATHER: Shut up and fight boy.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: With pleasure.");
                Console.ReadKey(true);
            }

            Console.Clear();
        }

        private static void EndingDialog(int level)
        {
            if (level == 4)
            {
                Console.WriteLine("FATHER: THIS IS IMPOSSIBLE.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: HAHAHAHAHA, YOU CAN'T FIGHT OLD MAN.");
                Console.ReadKey(true);
                Console.WriteLine("FATHER: BUT HE ONLY TOOK YOUR CORNFLAKES. WHY BEAT EVERYONE UP.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: BECAUSE IT HAD TO BE DONE. I HAD TO GET MY REVENGE ON THOSE LITTLE BRATS.");
                Console.ReadKey(true);
                Console.WriteLine("MOTHER: uuuhhm. Actually that's crazy. What the hell is happening.");
                Console.ReadKey(true);
                Console.WriteLine("FATHER: HERE TAKE THAT.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: NAH, YOU TAKE THAT");
                Console.ReadKey(true);
                Console.WriteLine("FATHER: AAAAAAAAAAHHHH");
                Console.ReadKey(true);
                Console.WriteLine("YOU: AAAAAAAHHHHHHHH");
                Console.ReadKey(true);
                Console.WriteLine("The power of those punches were just too crazy.");
                Console.ReadKey(true);
                Console.WriteLine("They both collapsed.");
                Console.ReadKey(true);
                Console.Clear();
                Console.WriteLine("10 minutes later");
                Console.ReadKey(true);
                Console.WriteLine("The police have arrived and captured you");
                Console.ReadKey(true);
                Console.WriteLine("POLICE OFFICER: You understand what you did. Did you?");
                Console.ReadKey(true);
                Console.WriteLine("YOU:...");
                Console.ReadKey(true);
                Console.WriteLine("POLICE OFFICER: It's crazy that you could beat up that old man.");
                Console.ReadKey(true);
                Console.WriteLine("POLICE OFFICER: I mean he's pretty strong.");
                Console.ReadKey(true);
                Console.WriteLine("YOU: do I get the cornflakes?");
                Console.ReadKey(true);
                Console.WriteLine("POLICE OFFICER: nah");
                Console.ReadKey(true);
                Console.WriteLine("YOU: Fu-");
                Console.ReadKey(true);
                Console.Clear();
                Console.ReadKey(true);
                Console.WriteLine("thank you for playing!!!");
                Console.ReadKey(true);
                Environment.Exit(0);
            }
        }



        enum Items
        {
            HealthPotion,
            ManaPotion
        }

        enum Magic
        {
            AttackMagic_1,
            DefenseMagic_1,
            AttackMagic_2,
            DefenseMagic_2,
            AttackMagic_3,
            DefenseMagic_3,
            AttackMagic_4,
            DefenseMagic_4
        }

        private static void PlayerTurn(ref int playerhp, ref int playerattack, int playerheal, ref int enemyhp, int enemyattack, ref int manapoints, int magicattack, ref int PlayerAttackCount, ref int playerDefense, ref bool isDefending, ref bool isDefenseMagic, ref int HealthPotionsLeft, ref int ManaPotionsLeft, ref bool isAttackMagic, int level, ref int AttackMagicCounter, ref int DefenseMagicCounter, int[] levelStartingPlayerHP, ref int[] ManaPotionsWert, ref int[] HealthPotionsWert)
        {
            while (true)
            {
                Console.WriteLine("Write 'a' for attack, 'm' for magic, 'd' for defense or 'i' for item. 'q' for quitting the game.");
                string selection = Console.ReadLine();
                Random rndn = new Random();
                int randomNumber_3 = rndn.Next(1, 11);

                if (selection == "a")
                {
                    if (isAttackMagic == true)
                    {
                        if (randomNumber_3 == 4)
                        {
                            enemyhp -= (playerattack + 1);
                            Console.WriteLine("Crazy. You dealt " + (playerattack + 2) + " damage");
                            AttackMagicCounter++;
                            AttackMagicReseter(ref playerattack, level, ref AttackMagicCounter, ref isAttackMagic);
                            break;
                        }
                        else
                        {
                            enemyhp -= playerattack;
                            Console.WriteLine("Enemy lost " + playerattack + " hp");
                            PlayerAttackCount++;
                            AttackMagicCounter++;
                            AttackMagicReseter(ref playerattack, level, ref AttackMagicCounter, ref isAttackMagic);
                            break;
                        }
                    }
                    else
                    {
                        if (randomNumber_3 == 4)
                        {
                            enemyhp -= (playerattack + 1);
                            Console.WriteLine("You hit him very good. You dealt " + (playerattack + 1) + " damage");
                            break;
                        }
                        else if (randomNumber_3 == 7 || randomNumber_3 == 2)
                        {
                            int dialogNumber = rndn.Next(0, 4);
                            if (dialogNumber == 0)
                            {
                                Console.WriteLine("Bruh, you missed.");
                            }
                            if (dialogNumber == 1)
                            {
                                Console.WriteLine("I mean, there is no way you actually missed right now.");
                            }
                            if (dialogNumber == 2)
                            {
                                Console.WriteLine("Hahahahaha, no way. You actually missed.");
                            }
                            if (dialogNumber == 3)
                            {
                                Console.WriteLine("Guess what? You missed. HAHAHAHA.");
                            }
                            break;
                        }
                        else
                        {
                            enemyhp -= playerattack;
                            Console.WriteLine("You dealt " + playerattack + " damage");
                            PlayerAttackCount++;
                            break;
                        }
                    }

                }

                if (selection == "i")
                {
                    Items chosenOption = Items.HealthPotion;

                    Console.Clear();
                    Console.WriteLine("1: Health Potion: You have " + HealthPotionsLeft + " Potions left");
                    Console.WriteLine("2: Magical Drink: You have " + ManaPotionsLeft + " Potions left");

                    ConsoleKeyInfo option = Console.ReadKey(true);
                    Console.ReadLine();

                    if (option.Key == ConsoleKey.D1)
                    {
                        if (HealthPotionsLeft > 0)
                        {
                            HealthPotionsLeft--;
                            chosenOption = Items.HealthPotion;
                        }
                        else
                        {
                            Console.WriteLine("You don't have any Healthy Potions left.");
                            continue;
                        }
                    }
                    else if (option.Key == ConsoleKey.D2)
                    {
                        if (ManaPotionsLeft > 0)
                        {
                            ManaPotionsLeft--;
                            chosenOption = Items.ManaPotion;
                        }
                        else
                        {
                            Console.WriteLine("You don't have any Magical Drinks left.");
                            continue;
                        }
                    }
                    else
                    {
                        continue;
                    }

                    switch (chosenOption)
                    {
                        case Items.HealthPotion:
                            playerhp += HealthPotionsWert[level - 1];
                            Console.WriteLine("You healed " + playerheal + " HP");
                            break;
                        case Items.ManaPotion:
                            manapoints += ManaPotionsWert[level - 1];
                            Console.WriteLine("You restored 5 Manapoints.");
                            break;
                        default:
                            break;
                    }
                    break;
                }

                if (selection == "m")
                {
                    Magic optionChosen = Magic.AttackMagic_1;

                    if (isAttackMagic == true || isDefenseMagic == true)
                    {
                        Console.WriteLine("Magic is active. You can't use two at the same time.");
                        continue;
                    }

                    Console.Clear();
                    if (level == 1)
                    {
                        Console.WriteLine("(1) Shield of the novice: 5 Mana Points (Your defense increases for 2 rounds.)");
                        Console.WriteLine("(2) Flame burst: 5 Mana Points (Your attack increases for 2 rounds.)");
                    }
                    if (level == 2)
                    {
                        Console.WriteLine("(1) Frost barrier: 8 Mana Points");
                        Console.WriteLine("(2) Ice lance: 8 Mana Points");
                    }
                    if (level == 3)
                    {
                        Console.WriteLine("(1) Ethereal refuge: 10 Mana Points");
                        Console.WriteLine("(2) Lightning explosion: 10 Mana Points");
                    }
                    if (level == 4)
                    {
                        Console.WriteLine("(1) Time shift veil: 15 Manapunkte");
                        Console.WriteLine("(2) Meteor shower: 15 Manapunkte");
                    }
                    ConsoleKeyInfo key = Console.ReadKey(true);

                    if (manapoints <= 0)
                    {
                        Console.WriteLine("Du hast keine Manapunkte mehr");
                        continue;
                    }
                    else if (!(key.Key == ConsoleKey.D1 || key.Key == ConsoleKey.D2))
                    {
                        Console.WriteLine("Wrong input");
                        ShowStats(ref playerhp, ref enemyhp, ref manapoints);
                        continue;
                    }
                    else
                    {
                        if (level == 1)
                        {
                            if (key.Key == ConsoleKey.D1)
                            {
                                manapoints -= 5;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.DefenseMagic_1;
                            }
                            if (key.Key == ConsoleKey.D2)
                            {
                                manapoints -= 5;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.AttackMagic_1;
                            }
                        }

                        else if (level == 2)
                        {
                            if (key.Key == ConsoleKey.D1)
                            {
                                manapoints -= 8;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.DefenseMagic_2;
                            }
                            if (key.Key == ConsoleKey.D2)
                            {
                                manapoints -= 8;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.AttackMagic_2;
                            }
                        }

                        else if (level == 3)
                        {
                            if (key.Key == ConsoleKey.D1)
                            {
                                manapoints -= 10;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.DefenseMagic_3;
                            }
                            if (key.Key == ConsoleKey.D2)
                            {
                                manapoints -= 10;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.AttackMagic_3;
                            }
                        }

                        else if (level == 4)
                        {
                            if (key.Key == ConsoleKey.D1)
                            {
                                manapoints -= 15;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.AttackMagic_4;
                            }
                            if (key.Key == ConsoleKey.D2)
                            {
                                manapoints -= 15;
                                EnoughManaPoints(ref manapoints, level);
                                optionChosen = Magic.AttackMagic_4;
                            }
                        }
                    }

                    switch (optionChosen)
                    {
                        case Magic.DefenseMagic_1:
                            isDefenseMagic = true;
                            playerDefense += 3;
                            Console.WriteLine("You now have 3 more Defense for the next two rounds.");
                            break;
                        case Magic.AttackMagic_1:
                            isAttackMagic = true;
                            playerattack += 3;
                            Console.WriteLine("You're Attack increased. You have " + playerattack + " attack now.");
                            break;
                        case Magic.DefenseMagic_2:
                            isDefenseMagic = true;
                            playerDefense += 5;
                            Console.WriteLine("You now have 5 more Defense for the next two rounds.");
                            break;
                        case Magic.AttackMagic_2:
                            isAttackMagic = true;
                            playerattack += 5;
                            Console.WriteLine("You're Attack increased. You have " + playerattack + " attack now.");
                            break;
                        case Magic.DefenseMagic_3:
                            isDefenseMagic = true;
                            playerDefense += 6;
                            Console.WriteLine("You now have 8 more Defense for the next two rounds.");
                            break;
                        case Magic.AttackMagic_3:
                            isAttackMagic = true;
                            playerattack += 6;
                            Console.WriteLine("You're Attack increased. You have " + playerattack + " attack now.");
                            break;
                        case Magic.DefenseMagic_4:
                            isDefenseMagic = true;
                            playerDefense += 8;
                            Console.WriteLine("You now have 12 more Defense for the next two rounds.");
                            break;
                        case Magic.AttackMagic_4:
                            isAttackMagic = true;
                            playerattack += 8;
                            Console.WriteLine("You're Attack increased. You have " + playerattack + " attack now.");
                            break;
                    }
                    break;
                }

                if (selection == "d")
                {
                    int numberRandom = rndn.Next(0, 31);
                    int fullHealRandomNumber = rndn.Next(1, 101);

                    if (numberRandom == 15)
                    {
                        playerhp += 8;
                        Console.WriteLine("You defended. You could recover 8 HP.");
                    }

                    if (numberRandom == 9)
                    {
                        playerhp += 5;
                        Console.WriteLine("Somehow you managed to heal 5 HP. It was probably the defense that made it possible.");
                    }

                    if (fullHealRandomNumber == 63)
                    {
                        playerhp = levelStartingPlayerHP[level - 1];
                        Console.WriteLine("OH MY GOD. I DON'T KNOW WHAT JUST HAPPENED. YOU ACTUALLY JUST HEALED FULLY. that's crazy. (1% chance for this to happen) ");
                    }
                    isDefending = true;
                    break;
                }
                if (selection == "q")
                {
                    Environment.Exit(0);
                }
                else
                {
                    Console.WriteLine("'a' for attack, 'i' for item, 'd' for defense or 'm' for magic");
                }
            }
        }


        enum EnemyState
        {
            Attack = 1,
            Heal = 2,
            Special = 3,
            CritAttack = 4,
            Miss = 5
        }
        private static void EnemyTurn(ref int enemyhp, int enemyattack, int enemyheal, ref int playerhp, ref int playerattack, ref int enemymagicattack, ref int enemymanapoints, ref int PlayerAttackCount, int NeededPlayerAttackCount, int playerDefense, ref bool isDefending, ref bool isDefenseMagic, ref bool isAttackMagic, int level, ref int level4Heal)
        {
            Random rnd = new Random();
            EnemyState action;

            if (level == 4 && enemyhp <= 20 && level4Heal == 0)
            {
                action = EnemyState.Heal;
            }

            else if (PlayerAttackCount == NeededPlayerAttackCount || rnd.NextDouble() < 0.2)
            {
                action = EnemyState.Heal;
            }

            else if (enemyhp < (enemyhp / 2))
            {
                int randomNumberSpecial = rnd.Next(1, 11);
                if (randomNumberSpecial == 7 || randomNumberSpecial == 2)
                {
                    action = EnemyState.Special;
                }
                else
                {
                    action = EnemyState.Attack;
                }
            }

            else
            {
                int randomNumber = rnd.Next(1, 11);

                if (randomNumber == 3 || randomNumber == 6)
                {
                    if (isDefending == true)
                    {
                        action = EnemyState.Attack;
                    }
                    else
                    {
                        action = EnemyState.CritAttack;
                    }
                }

                else if (randomNumber == 4)
                {
                    if (isAttackMagic == true)
                    {
                        action = EnemyState.Attack;
                    }
                    else
                    {
                        action = EnemyState.Miss;
                    }
                }

                else
                {
                    action = EnemyState.Attack;
                }
            }

            switch (action)
            {
                case EnemyState.Attack:
                    if (isDefending == true || isDefenseMagic == true)
                    {
                        int enemydamage = enemyattack - playerDefense;
                        if (isDefenseMagic == true)
                        {
                            EnemyAttackWhenPlayerDefense(enemydamage, ref playerDefense, ref playerhp, ref isDefenseMagic);
                        }
                        else
                        {
                            enemydamage = enemyattack - playerDefense;
                            if (enemydamage == 0)
                            {
                                Console.WriteLine("He literally made no damage.");
                            }
                            else
                            {
                                if (enemydamage < 0)
                                {
                                    enemydamage = 0;
                                }

                                playerhp -= enemydamage;
                                Console.WriteLine("Player blocked the enemy's attack but still made " + enemydamage + " damage");
                            }
                        }
                    }
                    else
                    {
                        if (isDefending == false)
                        {
                            playerhp -= enemyattack;
                            Console.WriteLine("Player lost " + enemyattack + " HP");
                        }
                    }
                    isDefending = false;
                    break;
                case EnemyState.Heal:
                    if (level == 4)
                    {
                        if (level4Heal >= 1 || enemyhp >= 11)
                        {
                            enemyhp += enemyheal;
                            Console.WriteLine("Enemy healed " + enemyheal + " life");
                        }
                        else
                        {
                            level4Heal += 1;
                            enemyhp += 100;
                            Console.WriteLine("Enemy healed 100 HP. Have fun :)");
                        }
                    }
                    else
                    {
                        enemyhp += enemyheal;
                        Console.WriteLine("Enemy healed " + enemyheal + " HP");
                    }
                    break;
                case EnemyState.Special:
                    if (enemymanapoints > 0)
                    {
                        playerhp -= enemymagicattack;
                        Console.WriteLine("Enemy used Special attack and dealed " + enemymagicattack + " damage");
                        enemymanapoints -= 1;
                    }
                    else
                    {
                        action = EnemyState.Attack;
                    }
                    isDefending = false;
                    break;
                case EnemyState.CritAttack:
                    playerhp -= (enemyattack - 2);
                    Console.WriteLine("You could dodge a little bit. The enemy only dealt " + (enemyattack - 2) + " damage");
                    isDefending = false;
                    break;
                case EnemyState.Miss:
                    Console.WriteLine("You dodged exquisitely. You took no damage.");
                    isDefending = false;
                    break;
            }
        }

        private static void ShowStats(ref int playerhp, ref int enemyhp, ref int manapoints)
        {
            Console.WriteLine("HP Player: " + playerhp);
            Console.WriteLine("Mana Points: " + manapoints);
            Console.WriteLine("HP Enemy: " + enemyhp);
        }

        public static void EnemyAttackWhenPlayerDefense(int enemydamage, ref int playerDefense, ref int playerhp, ref bool isDefenseMagic)
        {

            if (enemydamage < 0)
            {
                enemydamage = 0;
            }
            playerhp -= enemydamage;
            if (enemydamage == 0)
            {
                Console.WriteLine("You're defense is too crazy. The enemy made NO damage.");
                Console.WriteLine("You're defenseMagic not active now.");
                playerDefense -= 5;
            }
            else
            {
                Console.WriteLine("Player blocked the enemy's attack but still made " + enemydamage + " damage");
                Console.WriteLine("You're defenseMagic not active now.");
                playerDefense -= 5;
            }
            isDefenseMagic = false;
        }

        public static void AttackMagicReseter(ref int playerattack, int level, ref int AttackMagicCounter, ref bool isAttackMagic)
        {
            if (level == 1)
            {
                if (AttackMagicCounter == 2)
                {
                    Console.WriteLine("Your magic is not active.");
                    playerattack -= 3;
                    AttackMagicCounter = 0;
                    isAttackMagic = false;
                }
            }
            else if (level == 2)
            {
                if (AttackMagicCounter == 2)
                {
                    Console.WriteLine("Your magic is not active.");
                    playerattack -= 5;
                    AttackMagicCounter = 0;
                    isAttackMagic = false;
                }
            }
            else if (level == 3)
            {
                if (AttackMagicCounter == 2)
                {
                    Console.WriteLine("Your magic is not active.");
                    playerattack -= 8;
                    AttackMagicCounter = 0;
                    isAttackMagic = false;
                }
            }
            else if (level == 4)
            {
                if (AttackMagicCounter == 2)
                {
                    Console.WriteLine("Your magic is not active.");
                    playerattack -= 12;
                    AttackMagicCounter = 0;
                    isAttackMagic = false;
                }
            }
        }
        public static void DefenseMagicReseter(ref int playerdefense, int level, ref int DefenseMagicCounter)
        {
            if (level == 1)
            {
                playerdefense -= 3;
            }
            else if (level == 2)
            {
                playerdefense -= 5;
            }
            else if (level == 3)
            {
                playerdefense -= 6;
            }
            else if (level == 4)
            {
                playerdefense -= 8;
            }
        }
        public static void EnoughManaPoints(ref int manapoints, int level)
        {
            int[] ManaPointsGiven = new int[] { 5, 8, 10, 15 };
            if (manapoints < 0)
            {
                manapoints = manapoints + ManaPointsGiven[level - 1];
                Console.WriteLine("You don't have enough Manapoints");
            }
        }
    }
}